<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function ads()
    {
        return $this->hasMany('Ad');
    }

    public function messages()
    {
        return $this->hasMany('Message');
    }

    public function favorites()
    {
        return $this->hasMany('Favorite');
    }

    public function ratings()
    {
        return $this->hasMany('Rating');
    }

    public function toConversations()
    {
        return $this->hasMany('Conversation', 'to_id');
    }

    public function fromConversations()
    {
        return $this->hasOne('Conversation', 'from_id');
    }

    public function accounts()
    {
        return $this->hasMany('Account');
    }

}